/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.fluid;

import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.LongData;
import com.blamejared.crafttweaker.api.data.op.IDataOps;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.impl.fluid.SimpleFluidStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import net.minecraft.class_3611;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import net.minecraft.class_9335;
import org.openzen.zencode.java.ZenCodeType;

public class MCFluidStack
implements IFluidStack {
    private final SimpleFluidStack stack;

    public MCFluidStack(SimpleFluidStack fluidStack) {
        this.stack = fluidStack;
    }

    @Override
    public boolean isEmpty() {
        return this.getInternal().isEmpty();
    }

    @Override
    public long getAmount() {
        return this.getInternal().amount();
    }

    @Override
    public IFluidStack setAmount(int amount) {
        SimpleFluidStack copy = this.getInternal().copy();
        copy.amount(amount);
        return IFluidStack.of(copy);
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public class_3611 getFluid() {
        return this.getInternal().fluid();
    }

    public SimpleFluidStack getInternal() {
        return this.stack;
    }

    public SimpleFluidStack getImmutableInternal() {
        return this.stack.copy();
    }

    @Override
    public IData asIData() {
        IData data = IFluidStack.super.asIData();
        data.put("amount", new LongData(this.getAmount()));
        return data;
    }

    @Override
    public Codec<IFluidStack> codec() {
        return SimpleFluidStack.CODEC.xmap(IFluidStack::of, IFluidStack::getInternal);
    }

    @Override
    public class_9335 getComponents() {
        return this.getInternal().getComponents();
    }

    @Override
    public <T> IFluidStack with(class_9331<T> type, @ZenCodeType.Nullable T value) {
        SimpleFluidStack copy = this.getInternal().copy();
        copy.set(type, value);
        return IFluidStack.of(copy);
    }

    @Override
    public IFluidStack withJsonComponent(class_9331 type, @ZenCodeType.Nullable IData value) {
        SimpleFluidStack copy = this.getInternal().copy();
        if (value == null) {
            copy.remove(type);
        } else {
            Codec codec = type.method_57876();
            DataResult decode = codec.decode(IDataOps.INSTANCE.withTagAddingRegistryAccess(), (Object)value);
            copy.set(type, ((Pair)decode.getOrThrow()).getFirst());
        }
        return IFluidStack.of(copy);
    }

    @Override
    public IFluidStack withJsonComponents(IData value) {
        SimpleFluidStack copy = this.getInternal().copy();
        DataResult decoded = class_9326.field_49589.decode(IDataOps.INSTANCE.withTagAddingRegistryAccess(), (Object)value);
        Pair pair = (Pair)decoded.getOrThrow();
        copy.applyComponents((class_9326)pair.getFirst());
        return IFluidStack.of(copy);
    }

    @Override
    public <T> IFluidStack remove(class_9331<T> type) {
        SimpleFluidStack copy = this.getInternal().copy();
        copy.remove(type);
        return IFluidStack.of(copy);
    }

    @Override
    public <T, U> IFluidStack update(class_9331<T> type, T defaultValue, U data, BiFunction<T, U, T> operator) {
        SimpleFluidStack copy = this.getInternal().copy();
        copy.update(type, defaultValue, data, operator);
        return IFluidStack.of(copy);
    }

    @Override
    public <T> IFluidStack update(class_9331<T> type, T defaultValue, UnaryOperator<T> operator) {
        SimpleFluidStack copy = this.getInternal().copy();
        copy.update(type, defaultValue, operator);
        return IFluidStack.of(copy);
    }

    @Override
    public IFluidStack applyComponents(class_9323 map) {
        SimpleFluidStack copy = this.getInternal().copy();
        copy.applyComponents(map);
        return IFluidStack.of(copy);
    }

    @Override
    public IFluidStack applyComponents(class_9326 patch) {
        SimpleFluidStack copy = this.getInternal().copy();
        copy.applyComponents(patch);
        return IFluidStack.of(copy);
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.EQUALS)
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleFluidStack thatStack = ((MCFluidStack)o).getInternal();
        SimpleFluidStack thisStack = this.getInternal();
        return SimpleFluidStack.matches(thisStack, thatStack);
    }

    public int hashCode() {
        return Long.hashCode(this.getInternal().amount()) + SimpleFluidStack.hashFluidAndComponents(this.getInternal());
    }
}

